/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.io;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.Rule;
import net.loomchild.segment.srx.SrxDocument;
import net.loomchild.segment.srx.SrxParser;
import net.loomchild.segment.util.Util;
import net.loomchild.segment.util.XmlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Srx2SaxParser
implements SrxParser {
    public static final String VALIDATE_PARAMETER = "validate";
    public static final boolean DEFAULT_VALIDATE = true;
    private static final Log log = LogFactory.getLog(Srx2SaxParser.class);
    private static final String SCHEMA = "net/loomchild/segment/res/xml/srx20.xsd";
    private SAXParserFactory factory;

    public Srx2SaxParser() {
        this(Util.getEmptyParameterMap());
    }

    public Srx2SaxParser(Map<String, Object> parameterMap) {
        boolean validate = Util.getParameter(parameterMap.get(VALIDATE_PARAMETER), true);
        this.factory = SAXParserFactory.newInstance();
        this.factory.setValidating(false);
        this.factory.setNamespaceAware(true);
        if (validate) {
            this.factory.setSchema(Util.getSchema(Util.getReader(Util.getResourceStream(SCHEMA))));
        }
    }

    @Override
    public SrxDocument parse(Reader reader) {
        try {
            SAXParser parser = this.factory.newSAXParser();
            SrxDocument document = new SrxDocument();
            InputSource source = new InputSource(reader);
            source.setEncoding("UTF-8");
            SrxHandler handler = new SrxHandler(document);
            parser.parse(source, (DefaultHandler)handler);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("Parser configuration exception parsing SRX document", e);
        }
        catch (SAXException e) {
            throw new XmlException("SAX exception parsing SRX document", e);
        }
        catch (IOException e) {
            throw new XmlException("IO exception parsing SRX document", e);
        }
    }

    private static class SrxHandler
    extends DefaultHandler {
        private SrxDocument document;
        private String elementName;
        private Map<String, LanguageRule> languageRuleMap;
        private LanguageRule languageRule;
        private boolean breakRule;
        private StringBuilder beforeBreak;
        private StringBuilder afterBreak;

        public SrxHandler(SrxDocument document) {
            this.document = document;
        }

        public void startDocument() throws SAXException {
            this.languageRuleMap = new HashMap<String, LanguageRule>();
            this.beforeBreak = new StringBuilder();
            this.afterBreak = new StringBuilder();
            this.resetRule();
        }

        public void endDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.elementName = localName;
            if ("header".equals(localName)) {
                this.document.setCascade("yes".equals(this.getValue(attributes, "cascade")));
            } else if ("languagerule".equals(localName)) {
                String languageRuleName = this.getValue(attributes, "languagerulename");
                this.languageRule = new LanguageRule(languageRuleName);
                this.languageRuleMap.put(this.languageRule.getName(), this.languageRule);
            } else if ("languagemap".equals(localName)) {
                String languagePattern = this.getValue(attributes, "languagepattern");
                String languageRuleName = this.getValue(attributes, "languagerulename");
                this.document.addLanguageMap(languagePattern, this.languageRuleMap.get(languageRuleName));
            } else if ("rule".equals(localName)) {
                this.breakRule = !"no".equals(this.getValue(attributes, "break"));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.elementName = null;
            if ("rule".equals(localName)) {
                String beforeBreakString = this.beforeBreak.toString();
                String afterBreakString = this.afterBreak.toString();
                Rule rule = new Rule(this.breakRule, beforeBreakString, afterBreakString);
                this.languageRule.addRule(rule);
                this.resetRule();
            }
        }

        public void characters(char[] ch, int start2, int length) throws SAXException {
            if ("beforebreak".equals(this.elementName)) {
                this.beforeBreak.append(ch, start2, length);
            } else if ("afterbreak".equals(this.elementName)) {
                this.afterBreak.append(ch, start2, length);
            }
        }

        public void fatalError(SAXParseException e) {
            throw new XmlException("Fatal error parsing SRX", e);
        }

        public void error(SAXParseException e) {
            throw new XmlException("Error parsing SRX", e);
        }

        public void warning(SAXParseException e) {
            throw new XmlException("Warning parsing SRX", e);
        }

        private void resetRule() {
            this.breakRule = false;
            this.beforeBreak.setLength(0);
            this.afterBreak.setLength(0);
        }

        private String getValue(Attributes attributes, String localName) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!localName.equals(attributes.getLocalName(i))) continue;
                return attributes.getValue(i);
            }
            return null;
        }
    }
}

